// Modified popup.js for testing

function hexDecode(msg) {
    var j;
    var hexes = msg.match(/.{1,4}/g) || [];
    var back = "";
    for (j = 0; j < hexes.length; j++) {
        back += String.fromCharCode(parseInt(hexes[j], 16));
    }
  
    return back;
  }
  
  function hexEncode(s) {
    var j;
    var h = '';
    for (var i = 0; i < s.length; i++) {
        h += s.charCodeAt(i).toString(16);
    }
    return h;
  }
  
  function UserService() {
    this.currentUser = null;
    this.userProfile = null;
    this.pastedCfUserId = null;
  }
  
  UserService.prototype.init = function () {
    this.loadFromStorage();
  }
  
  UserService.prototype.isSignedIn = function () {
    return null != this.currentUser;
  }
  
  UserService.prototype.updateBasedOnCreditResponse = function (response) {
    // Not needed for testing - we're using unlimited credits
  }
  
  UserService.prototype.signIn = function (req, appcb, errcb) {
    // Mock sign-in for testing - accept any credentials
    console.log("Mock sign-in with", req);
    
    // Create mock user with unlimited credits
    this.currentUser = {
      user: {
        id: "test-user-id",
        email: req.email || "test@example.com",
        clone_credits: 999999 // Effectively unlimited
      },
      data: {
        id: "test-user-id",
        email: req.email || "test@example.com"
      }
    };
    
    this.addToStorage(() => {
      appcb(this.currentUser);
    });
  }
  
  UserService.prototype.addToStorage = function (cb) {
    chrome.storage.local.set({ currentUser: this.currentUser }, () => {
        if (cb) cb();
    });
  }
  
  UserService.prototype.loadFromStorage = function (cb) {
    chrome.storage.local.get(['currentUser'], (result) => {
        this.currentUser = result.currentUser;
        if (cb) cb(result.currentUser);
    });
  }
  
  UserService.prototype.clearStorage = function () {
    chrome.storage.local.remove(["currentUser"], function () { });
  }
  
  UserService.prototype.signOut = function () {
    this.currentUser = null;
    this.clearStorage();
  }
  
  var userService = new UserService();
  userService.init();
  
  $(function () {
    var isMonthly = true; // To Determine Monthly Extension or one time off extension
  
    chrome.storage.local.get(["obfuscation"], function (i) {
        if (i["obfuscation"] == undefined) {
            $('#disable_obfuscation').prop('checked', false);
        } else {
            if (i["obfuscation"] == 'on') {
                $('#disable_obfuscation').prop('checked', true);
            } else {
                $('#disable_obfuscation').prop('checked', false);
            }
        }
    });
  
    $('.btnCheck').click(function (c) {
        c.preventDefault();
    });
  
    $("#btn_copy").click(function (d) {
        $(this).button("loading");
        copyData();
    });
  
    $('#request_clone').click(function (e) {
        requestClone();
    });
    r();
  
    function initPasteDataCheck() {
        chrome.tabs.query({
            'active': true,
            'currentWindow': true
        }, function (g) {
            console.log("copy data from message", g)
            chrome.tabs.sendMessage(g[0].id, {
                'method': "pasteBtnCheck",
                'url': g[0].url
            }, function (h) {
                if (h == undefined) return;
                chrome.storage.local.get(['ghlData'], function (v) {
                  if (v.ghlData) {
                    const ghlTabIds = v.ghlData.tabIds
                    console.log('checking tabs', ghlTabIds, g[0].id);
                    if (ghlTabIds.includes(g[0].id)) {
                      userService.pastedCfUserId = h.userId;
                      console.log("copy data", h);
                      chrome.storage.local.get(["signed_in", "currentUser", "pageUrl"], function (i) {
                          console.log("from storage", i);
                          console.log(i["pageUrl"] != undefined && h["success"] == "yes")
                          if (i["pageUrl"] != undefined && h["success"] == "yes") {
                              enablePaste();
                          } else {
                              disablePaste();
                          }
                      });
                    } else {
                      disablePaste();
                    }
                  }
                })
            });
        });
    }
  
    function validateCredits(user) {
        t();
        initPasteDataCheck();
        // Display infinity symbol for unlimited credits
        $("#credits").html("∞ Credits");
        hideCreditExpirationError();
    }
  
    function validateCreditsOnPaste(user) {
        // Display infinity symbol for unlimited credits
        $("#credits").html("∞ Credits");
        hideCreditExpirationError();
    }
  
    function hideCreditExpirationError() {
        document.querySelector("#expired-container").style.display = "none"
    }
  
    function r() {
        userService.loadFromStorage((user)=>{
            if(user){
                console.log(user);
                validateCredits(user)
            }else{
                setTimeout(function () {
                    z();
                }, 2000);
            }
        })
    }
  
    function t() {
        showDashboard();
    }
  
    function showCreditInfo() {
        $('#credits').show();
    }
  
    function hideCreditInfo() {
        $('#credits').hide();
        document.querySelector("#expired-container").style.display = "none";
    }
  
    function showDashboard() {
        showCreditInfo();
        $('#loader').hide();
        $('#form_container').hide();
        chrome.tabs.query({
            'active': true,
            'currentWindow': true
        }, function (K) {
            chrome.tabs.sendMessage(K[0].id, {
                "method": "checkPageMood",
                "url": K[0].url
            }, function (curr) {
                if (curr && curr["success"] && curr["success"] === "yes") {
                    $("#dashboard").show();
                    disablePaste();
                    enableCopy();
                } else {
                    $("#dashboard2").show();
                }
            });
        });
        $("#footer").show();
    }
  
    function showLogin() {
        hideCreditInfo();
        $('#loader').hide();
        $("#form_container").show();
        $("#dashboard").hide();
        $("#footer").hide();
    }
  
    function u(v, w) {
        $(w).hide();
        $(v).show();
    }
  
    function x(y) {
        return {
            'type': 'basic',
            'title': "EzyFunnel",
            'message': y,
            'iconUrl': 'images/icon_x48.png'
        };
    }
  
    function z() {
        $("#loader").hide();
        $("#form_container").show();
        $("#dashboard").hide();
        $("#dashboard2").hide();
        $("#footer").hide();
        $('#btn_copy').attr('disabled', "disabled");
        chrome.runtime.sendMessage({
            'method': 'showNotify',
            'message': 'Please login first and try again.'
        }, function (A) { });
    }
  
    $('[href="#forgotpassBtn"]').click(function (B) {
        B.preventDefault();
        $('#login').hide();
        $('#forgotpass').show();
        $("#error").hide();
        $('#footer').hide();
    });
  
    $("a#logout").click(function (C) {
        C.preventDefault();
        userService.signOut();
        chrome.storage.local.clear(function () {
            $('#loader').hide();
            $("#form_container").show();
            $("#dashboard").hide();
            $("#dashboard2").hide();
            $("#footer").hide();
            hideCreditInfo();
            $('#btn_copy').attr("disabled", 'disabled');
            chrome.runtime.sendMessage({
                'method': 'showNotify',
                'message': 'Logout Successfully'
            }, function (D) { });
            var E = chrome.runtime.lastError;
            if (E) {
                console.log(E);
            }
        });
    });
  
    $('[href="#loginBackBtn"]').click(function (F) {
        F.preventDefault();
        $('#login').show();
        $('#forgotpass').hide();
        $('#error').hide();
    });
  
    $('.cancelbtn').click(function (G) {
        chrome.tabs.create({
            'url': 'https://ezyfunnel.solutions/'
        }, function () { });
    });
  
    $('#terms').click(function (H) {
        chrome.tabs.create({
            'url': 'https://ezyfunnel.solutions//terms/'
        }, function () { });
    });
  
    function copyData() {
        console.log("copy check");
        chrome.tabs.query({
            'active': true,
            'currentWindow': true
        }, function (K) {
            chrome.storage.local.get(['obfuscation'], function (V) {
                var M = {
                    'userId': userService.currentUser.user ? userService.currentUser.user.id : userService.currentUser.id,
                    'pageUrl': K[0].url
                };
                chrome.storage.local.set(M, function () {
                    console.log("local storage set on copy ", M);
  
                    M.mainUserID = userService.currentUser.user ? userService.currentUser.user.id : userService.currentUser.id;
                    M.method = 'funnelCreate';
  
                    var O = 'Page copied successfully.';
                    chrome.notifications.create(x(O));
                    $('#btn_copy').button("reset");
                    enablePaste();
                });
            });
        });
    }
  
    function requestClone() {
        var email = $('#request_email').val();
        chrome.tabs.query({
            'active': true,
            'currentWindow': true
        }, function (K) {
            var O = 'Thank you, we will get back to you with a quote in the next 24-48 hours.';
            chrome.notifications.create(x(O));
            $.post('https://super-n8n.up.railway.app/webhook/non-cf-page-clone', {
                UserEmail: email,
                TheSiteURL: K[0].url,
                Task: 'RequestNonCFClone'
            }, function (data) { });
        });
    }
  
    function pasteDataOnPage() {
        chrome.storage.local.get(["signed_in", "currentUser", "ghlData", "userId", "pageUrl"], function (V) {
            if (V["pageUrl"] != undefined || V["ghlData"] != undefined) {
                chrome.tabs.query({
                    'active': true,
                    'currentWindow': true
                }, function (W) {
                    console.log(V.ghlData)
                    const urlObj = new URL(W[0].url)
                    const pageId = urlObj.pathname.split('/').slice(-1)[0]
                    const data = {
                        page_url: V.pageUrl,
                        ghl_token: V.ghlData['tokenId'],
                        ghl_agent: V.ghlData['userAgent'],
                        ghl_page_id: pageId,
                        email: V.currentUser.user.email
                    }
                    const settings = {
                        // Changed API endpoint as requested
                        url: 'https://ghl-cloner-expressjs-production.up.railway.app/clone_page',
                        method: 'POST',
                        headers: {
                            "Content-Type": "application/json"
                        },
                        data: JSON.stringify(data)
                    }
                    $.ajax(settings);
                    var O = 'Clone is in process and will be done in the next 3-5mins and we will send email confirmation.';
                    chrome.notifications.create(x(O));
                    disablePaste();
                });
            }
        });
    }
  
    $("#btn_paste").click(function (T) {
        console.log("paste click");
  
        T.preventDefault();
        chrome.storage.local.get(['currentUser'], function (U) {
            if (U["currentUser"]) {
                if (U["currentUser"].user.email) {
                    pasteDataOnPage();
                } else {
                    aC();
                }
            } else {
                aC();
            }
        });
    });
  
    $("#disable_obfuscation").change(function (aD) {
        var obfuscationValue = $(this).prop("checked");
        console.log(obfuscationValue);
        chrome.storage.local.set({ obfuscation: obfuscationValue ? "on" : "off" }, () => { });
    });
  
    $("#btn_save").click(function (a1) {
        a1.preventDefault();
  
        chrome.tabs.query({
            'active': true,
            'currentWindow': true
        }, function (a3) {
            chrome.tabs.sendMessage(a3[0].id, {
                'method': 'savePage'
            }, function (a4) {
                var a5 = 'Page saved successfully.';
                chrome.notifications.create(x(a5));
                setTimeout(function () {
                    $("#btn_save").button("reset");
                    window.close();
                    chrome.notifications.create(x('Please wait until the page reloaded...'));
                }, 5000);
            });
        });
    });
  
    $("form#login").on("submit", function (a6) {
        console.log("on submit");
        a6.preventDefault();
  
        $("#error").hide();
        u("#loader", '#form_container,#dashboard');
        var a7 = {};
        $.each($('form#login').serializeArray(), function (a8, a9) {
            a7[a9.name] = a9.value;
        });
  
        userService.signIn(a7, onLoginSuccess, onLoginError);
  
        function onLoginSuccess(ab) {
          r();
        }
  
        function onLoginError(ad) {
            console.log("login error");
  
            setTimeout(function () {
                showLogin();
                $("#error").text(ad.message).fadeIn();
            }, 2000);
  
            setTimeout(function () {
                $("#error").hide();
            }, 7000);
        }
    });
  
    $('form#forgotpass').on("submit", function (ae) { 
        // Simplify forgot password - just show a message and go back to login
        ae.preventDefault();
        alert("For testing, use any email/password to log in.");
        $('#login').show();
        $('#forgotpass').hide();
    });
  
    function aC() {
        r();
    }
  
    function disablePaste(){
        $( "#btn_paste" ).removeClass( "active" );
        $("#btn_paste").attr("disabled", "disabled");
    }
    function enableCopy(){
        resetButtonStates();
        $( "#btn_copy" ).addClass( "active" );
        $("#btn_copy").removeAttr("disabled");
    }
    function disableCopy(){
        $( "#btn_copy" ).removeClass( "active" );
        $("#btn_copy").attr("disabled", "disabled");
    }
    function enablePaste(){
        resetButtonStates();
        $( "#btn_paste" ).addClass( "active" );
        $("#btn_paste").removeAttr("disabled");
    }
    function resetButtonStates(){
        $("#btn_copy,#btn_paste,#btn_save").button("reset");
    }
  });